(ns {{ns-name}}.core
  (:require [clojure.tools.cli :refer [parse-opts]]
            [{{ns-name}}
             [incubator :as i]
             [protocols :as p]
             [utils :refer :all]]
            [de.elbenwald.common
             [infra :as eci]
             [lang :refer :all]
             [utils :refer :all]]
            [medley.core :as m]
            [plumbing.core :refer :all]
            [uncomplicate.fluokitten.core :as f])
  (:gen-class))

(def cli-options
  [["-a" "--action-id ACTION" "Action" :default "test"]
   ["-h" "--help"]])

(defn -main [& args]
  (let [{:keys [options arguments errors summary]} (parse-opts args cli-options)]
    (when (:help options)
      (println summary))
    (case (:action-id options)
      "test" (println "Hello World"))))
