(ns {{ns-name}}.ajax
  (:require
    [ajax.core :as ajax]
    [cognitect.transit :as transit]
    [luminus-transit.time :as time]
    [re-frame.core :as rf]))

(defn local-uri?
  "TODO doc"
  [{:keys [uri]}]
  (not (re-find #"^\w+?://" uri)))

(defn default-headers
  "TODO doc"
  [request]
  (if (local-uri? request)
    (-> request
      (update :headers #(merge {"x-csrf-token" js/csrfToken} %)))
    request))

;; injects transit serialization config into request options
(defn as-transit
  "TODO doc"
  [opts]
  (merge {:raw              false
          :format           :transit
          :response-format  :transit
          :reader           (transit/reader :json time/time-deserialization-handlers)
          :writer           (transit/writer :json time/time-serialization-handlers)}
         opts))

(defn load-interceptors!
  "TODO doc"
  []
  (swap! ajax/default-interceptors
         conj
         (ajax/to-interceptor {:name "default headers"
                               :request default-headers})))
