(defproject {{project-name}} "0.1.0-SNAPSHOT"

  :description "Elbenwald {{name-short}}"
  :url "https://www.elbenwald.de"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :repositories [["releases" {:url "s3p://ew-tools/releases"
                              :creds :gpg}]
                 ["my.datomic.com" {:url "https://my.datomic.com/repo"
                                    :creds :gpg}]]

  :plugins [[s3-wagon-private "1.3.1" :exclusions [commons-logging]]
            [lein-cljsbuild "1.1.7"]]

  :dependencies [; common
                 [clj-time "0.15.1"]
                 [com.taoensso/encore "2.109.0"]
                 [cprop "0.1.14"]
                 [me.raynes/fs "1.4.6"]
                 [medley "1.1.0"]
                 [orchestra "2018.12.06-2"]
                 [org.clojure/algo.monads "0.1.6"]
                 [org.clojure/clojure "1.10.1"]
                 [org.clojure/core.async "0.4.490"]
                 [org.clojure/core.match "0.3.0"]
                 [org.clojure/tools.logging "0.5.0"]
                 [prismatic/plumbing "0.5.5"]
                 [prismatic/schema "1.1.11"]
                 [proto-repl "0.3.1"]
                 [slingshot "0.12.2"]
                 [uncomplicate/fluokitten "0.9.1"]

                 ; project
                 [ch.qos.logback/logback-classic "1.2.3"]
                 [cheshire "5.8.1"]
                 [cljs-ajax "0.8.0"]
                 [clojure.java-time "0.3.2"]
                 [com.cognitect/transit-clj "0.8.313"]
                 [com.taoensso/tempura "1.2.1"]
                 [com.walmartlabs/lacinia "0.35.0"]
                 [day8.re-frame/http-fx "0.1.6"]
                 [expound "0.7.2"]
                 [funcool/struct "1.4.0"]
                 [luminus-immutant "0.2.4"]
                 [luminus-transit "0.1.1"]
                 [luminus/ring-ttl-session "0.3.3"]
                 [markdown-clj "1.10.0"]
                 [metosin/muuntaja "0.6.4"]
                 [metosin/reitit "0.3.9"]
                 [metosin/ring-http-response "0.9.1"]
                 [mount "0.1.16"]
                 [nrepl "0.6.0"]
                 [org.clojure/clojurescript "1.10.520" :scope "provided"]
                 [org.clojure/tools.cli "0.4.2"]
                 [org.webjars.npm/bulma "0.7.5"]
                 [org.webjars.npm/material-icons "0.3.0"]
                 [org.webjars/jquery "3.4.1"]
                 [org.webjars/webjars-locator "0.36"]
                 [re-frame "0.10.8"]
                 [re-graph "0.1.5"]
                 [reagent "0.8.1"]
                 [ring-webjars "0.2.0"]
                 [ring/ring-core "1.7.1"]
                 [ring/ring-defaults "0.3.2"]
                 [selmer "1.12.14"]

                 ; libs
                 [ch.qos.logback/logback-classic "1.2.3"]
                 [de.elbenwald/app-common "0.2.0"]
                 [de.elbenwald/common "0.17.0"]
                 [de.elbenwald/fusion-auth "0.9.0"]
                 [de.elbenwald/security "0.8.0"]
                 [javax.mail/mail "1.4.7"]
                 [org.slf4j/log4j-over-slf4j "1.7.25"]]

                 ; conflicts
                 ; [args4j "2.33"]
                 ; [com.fasterxml.jackson.core/jackson-core "2.9.9"]
                 ; [com.fasterxml.jackson.core/jackson-databind "2.9.9"]
                 ; [com.google.guava/guava "25.1-jre"]
                 ; [metosin/jsonista "0.2.3"]
                 ; [org.apache.commons/commons-compress "1.18"]
                 ; [org.apache.httpcomponents/httpclient "4.5.5"]
                 ; [org.apache.httpcomponents/httpcore "4.4.10"]
                 ; [org.clojure/tools.macro "0.1.5"]
                 ; [org.clojure/tools.namespace "0.3.0-alpha4"]
                 ; [org.ow2.asm/asm "5.1"]]

  :min-lein-version "2.0.0"

  :jvm-opts []

  :resource-paths ["resources" "target/cljsbuild"]
  :source-paths ["src/clj" "src/cljs" "src/cljc"]
  :target-path "target/%s/"
  :test-paths ["test/clj"]

  :clean-targets ^{:protect false}
  [:target-path [:cljsbuild :builds :app :compiler :output-dir] [:cljsbuild :builds :app :compiler :output-to]]
  :figwheel
  {:http-server-root "public"
   :server-logfile "log/figwheel-logfile.log"
   :nrepl-port 7002
   :css-dirs ["resources/public/css"]
   :nrepl-middleware [cider.piggieback/wrap-cljs-repl]}

  :profiles
  {:uberjar {:omit-source true
             :prep-tasks ["compile" ["cljsbuild" "once" "min"]]
             :cljsbuild {:builds
                         {:min
                          {:source-paths ["src/cljc" "src/cljs" "env/prod/cljs"]
                           :compiler
                           {:output-dir "target/cljsbuild/public/js"
                            :output-to "target/cljsbuild/public/js/app.js"
                            :source-map "target/cljsbuild/public/js/app.js.map"
                            :optimizations :advanced
                            :pretty-print false
                            :infer-externs true
                            :closure-warnings
                            {:externs-validation :off :non-standard-jsdoc :off}
                            :externs ["externs/jquery-3.2.js"
                                      "react/externs/react.js"]}}}}
             :aot :all
             :jar-name "_{{name-short}}-%s.jar"
             :uberjar-name "{{name-short}}-%s.jar"
             :source-paths ["env/prod/clj"]
             :resource-paths ["env/prod/resources"]}

   :dev           [:project/dev :profiles/dev]
   :test          [:project/dev :project/test :profiles/test]
   :midje         [:project/dev :project/test :project/midje :profiles/test]

   :project/dev  {:jvm-opts ["-Dconf=dev-config.edn"]
                  :dependencies [[binaryage/devtools "0.9.10"]
                                 [cider/piggieback "0.4.1"]
                                 [doo "0.1.11"]
                                 [figwheel-sidecar "0.5.19"]
                                 [pjstadig/humane-test-output "0.9.0"]
                                 [prone "2019-07-08"]
                                 [re-frisk "0.5.4.1"]
                                 [ring/ring-devel "1.7.1"]
                                 [ring/ring-mock "0.4.0"]]
                  :plugins [[com.jakemccrary/lein-test-refresh "0.24.1"]
                            [lein-doo "0.1.11" :exclusions [org.clojure/clojure]]
                            [lein-figwheel "0.5.19" :exclusions [org.clojure/clojure]]
                            [lein-midje "3.2.1" :exclusions [org.clojure/clojure]]]
                  :cljsbuild {:builds
                              {:app
                               {:source-paths ["src/cljs" "src/cljc" "env/dev/cljs"]
                                :figwheel
                                {:on-jsload "{{ns-name}}.core/mount-components"
                                 :websocket-url "ws://localhost:3449/figwheel-ws"}
                                 ;
                                 ; tunnels 443 3449
                                 ; :websocket-url "wss://localhost:443/figwheel-ws"}
                                :compiler
                                {:asset-path "/js/out"
                                 :closure-defines {"re_frame.trace.trace_enabled_QMARK_" true}
                                 :main "{{ns-name}}.app"
                                 :optimizations :none
                                 :output-dir "target/cljsbuild/public/js/out"
                                 :output-to "target/cljsbuild/public/js/app.js"
                                 :preloads [re-frisk.preload]
                                 :pretty-print true
                                 :source-map true}}}}
                  :doo {:build "test"}
                  :source-paths ["env/dev/clj"]
                  :resource-paths ["env/dev/resources"]
                  :repl-options {:init-ns user}
                  :injections [(require 'pjstadig.humane-test-output)
                               (pjstadig.humane-test-output/activate!)]}

   :project/test {:jvm-opts ["-Dconf=test-config.edn"]
                  :resource-paths ["env/test/resources"]
                  :cljsbuild {:builds
                              {:test
                               {:source-paths ["src/cljc" "src/cljs" "test/cljs"]
                                :compiler
                                {:main "{{ns-name}}.doo-runner"
                                 :optimizations :whitespace
                                 :output-to "target/test.js"
                                 :pretty-print true}}}}}

   :project/midje {}

   :profiles/dev {}
   :profiles/test {}

   :release {:release-tasks [["vcs" "assert-committed"]
                             ["change" "version" "leiningen.release/bump-version" "release"]
                             ["vcs" "commit"]]}
   :deploy {:release-tasks [["vcs" "assert-committed"]
                            ["vcs" "tag"]
                            ["deploy"]]}
                            ;["vcs" "push"] ; FIXME store ssh password
   :snapshot {:release-tasks [["vcs" "assert-committed"]
                              ["change" "version" "leiningen.release/bump-version"]
                              ["vcs" "commit"]]}}

  :release-tasks []
  :deploy-branches ["master"]

  :main ^:skip-aot {{ns-name}}.core)
