/*
 * Copyright (c) 2018-2019, FusionAuth, All Rights Reserved
 */
'use strict';

var FusionAuth = FusionAuth || {};
FusionAuth.IdentityProvider = FusionAuth.IdentityProvider || {};

/**
 * @constructor
 */
FusionAuth.IdentityProvider.Google = function() {
  Prime.Utils.bindAll(this);

  // Load the client id
  var scripts = document.getElementsByTagName('script');
  var lastScript = new Prime.Document.Element(scripts[scripts.length - 1]);
  this.clientId = lastScript.getDataAttribute('clientId');

  Prime.Document.onReady(function() {
    this.button = Prime.Document.queryById('google-login-button');
    this.scope = this.button.getDataAttribute('scope');

    gapi.load('auth2', function() {
      // Retrieve the singleton for the GoogleAuth library and set up the client.
      var auth2 = gapi.auth2.init({
        client_id: this.clientId,
        scope: this.scope
      });

      auth2.attachClickHandler(this.button.domElement, {}, this._onSignIn, this._onFailure);
    }.bind(this));
  }.bind(this));
};

FusionAuth.IdentityProvider.Google.constructor = FusionAuth.IdentityProvider.Google;
FusionAuth.IdentityProvider.Google.prototype = {

  /* ===================================================================================================================
   * Private methods
   * ===================================================================================================================*/

  _onFailure: function(error) {
    console.log(error);
  },

  _onSignIn: function(response) {
    // Disconnect so we do not auto-login when we return to this page
    var auth2 = gapi.auth2.getAuthInstance();
    auth2.disconnect();

    this._loginCallback(response);
  },

  _loginCallback: function(response) {

    var state = encodeURIComponent(
        'client_id=' + encodeURIComponent(Prime.Document.queryFirst('input[name=client_id]').getValue())
        + '&metaData.device.name=' + encodeURIComponent(Prime.Document.queryFirst('input[name="metaData.device.name"]').getValue())
        + '&metaData.device.type=' + encodeURIComponent(Prime.Document.queryFirst('input[name="metaData.device.type"]').getValue())
        + '&nonce=' + encodeURIComponent(Prime.Document.queryFirst('input[name="nonce"]').getValue())
        + '&redirect_uri=' + encodeURIComponent(Prime.Document.queryFirst('input[name=redirect_uri]').getValue())
        + '&response_type=' + encodeURIComponent(Prime.Document.queryFirst('input[name=response_type]').getValue())
        + '&scope=' + encodeURIComponent(Prime.Document.queryFirst('input[name=scope]').getValue())
        + '&state=' + encodeURIComponent(Prime.Document.queryFirst('input[name=state]').getValue())
        + '&timezone=' + encodeURIComponent(Prime.Document.queryFirst('input[name=timezone]').getValue())
    );

    window.location.href = '/oauth2/callback'
        + '?token=' + encodeURIComponent(response.getAuthResponse().id_token)
        + '&identityProviderId=82339786-3dff-42a6-aac6-1f1ceecb6c46'
        + '&state=' + state;
  }
};

FusionAuth.IdentityProvider.Google.instance = new FusionAuth.IdentityProvider.Google();