(ns {{ns-name}}.routes.services
  (:require
    [clojure.java.io :as io]
    [{{ns-name}}.global :as global]
    [{{ns-name}}.global :refer [graphql web-security]]
    [{{ns-name}}.middleware.exception :as exception]
    [{{ns-name}}.middleware.formats :as formats]
    [{{ns-name}}.routes.services.graphql :as graphql]
    [de.elbenwald.app-common.protocols :as acp]
    [reitit.coercion.spec :as spec-coercion]
    [reitit.ring.coercion :as coercion]
    [reitit.ring.middleware.multipart :as multipart]
    [reitit.ring.middleware.muuntaja :as muuntaja]
    [reitit.ring.middleware.parameters :as parameters]
    [reitit.swagger :as swagger]
    [reitit.swagger-ui :as swagger-ui]
    [ring.util.http-response :refer :all]))

(defn service-routes []
  ["/api"
   {:coercion spec-coercion/coercion
    :muuntaja formats/instance
    :swagger {:id ::api}
    :middleware [;; query-params & form-params
                 parameters/parameters-middleware
                 ;; content-negotiation
                 muuntaja/format-negotiate-middleware
                 ;; encoding response body
                 muuntaja/format-response-middleware
                 ;; exception handling
                 exception/exception-middleware
                 ;; decoding request body
                 muuntaja/format-request-middleware
                 ;; coercing response bodys
                 coercion/coerce-response-middleware
                 ;; coercing request parameters
                 coercion/coerce-request-middleware
                 ;; multipart
                 multipart/multipart-middleware]}

   ;; swagger documentation
   ["" {:no-doc true
        :swagger {:info {:title "my-api"
                         :description "https://cljdoc.org/d/metosin/reitit"}}}

    ["/swagger.json"
     {:get (swagger/create-swagger-handler)}]

    ["/api-docs/*"
     {:get (swagger-ui/create-swagger-ui-handler
             {:url "/api/swagger.json"
              :config {:validator-url nil}})}]]

   ["/ping"
    {:get (constantly (ok {:message "pong"}))}]

   ["/graphql"
    {:post (fn [request]
             (acp/HandleRequest graphql :graphql-wui-post request))}]

   ["/graphql2"
    {:post (fn [request]
             (acp/HandleRequest graphql :graphql-api-post request))}]

   ["/graphql-ws"
    {:get (fn [request]
            (acp/HandleRequest graphql :graphql-ws-get request))}]])
