(ns {{ns-name}}.config
  (:require
    [cprop.core :refer [load-config]]
    [cprop.source :as source]
    [de.elbenwald.common.config :as ecc]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.io :as ecio]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.utils :refer :all]
    [me.raynes.fs :as fs]
    [mount.core :refer [args defstate]]
    [plumbing.graph :as g]))

(defstate env
  :start
  (let [secrets-dir (-> (System/getProperty "user.home")
                      (fs/file ".elbenwald"))]
    (ecc/load-config {:args {:secrets-dir (-> secrets-dir .getCanonicalPath)}
                      :entries {:ew ["elbenwald-infra" :secrets :edn]}
                      :sources {:secrets (-> secrets-dir ecio/new-fs-repository)}})))
