(ns {{ns-name}}.env
  (:require
    [clojure.tools.logging :as l]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.io :as ecio]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.utils :refer :all]
    [{{ns-name}}.app :as app]
    [{{ns-name}}.incubator :as i]
    [de.elbenwald.fusion-auth.core :as fac]
    [de.elbenwald.pixi-remote.remote :as prr]
    [de.elbenwald.pixi-remote.xml :as prx]
    [de.elbenwald.rabbitmq.core :as erc]
    [plumbing.core :refer :all]))

(defnk make-component-factory
  "TODO doc"
  [:as env]
  (-> (eci/new-common-component-factory)
    (prr/configure-pixi-remote-factory (->m pixi-credentials))
    (prx/configure-pixi-xml-factory {})
    (erc/configure-rabbitmqem-factory {})
    (fac/configure-fusion-auth-factory fusion-auth-info)
    (app/configure-app-factory {})
    (as-> $ (eci/new-component-factory {} $))))

(def defaults
  {:init
   (fn []
     (l/info "\n-=[{{ns-name}} started successfully"))

   :stop
   (fn []
     (l/info "\n-=[{{ns-name}} has shut down successfully]=-"))

   :make-component-factory make-component-factory})
