(ns {{ns-name}}.core
  (:require
    [clojure.tools.logging :as l]
    [{{ns-name}}.incubator :as i]
    [{{ns-name}}.protocols :as p]
    [{{ns-name}}.utils :refer :all]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.utils :refer :all]
    [medley.core :as m]
    [plumbing.core :refer :all]
    [uncomplicate.fluokitten.core :as f]))

(defn do-things
  [context]
  (letk [[x
          y] context]
    (+ x y)))

(defnew p/Lib)

(defnk new-lib
  "TODO doc"
  [data]
  (letk [[a
          b] data]
    (new+lib {:x a
              :y b})))

;
; component factory
;

(defdecorator p/Lib)

(defn configure-lib-factory
  "Adds a lib factory
   to the given component factory."
  [component-factory options]
  (let [f (fnk [error-mode
                data]
            (let [eh-decorator (eci/get-eh-decorator error-mode)]
              (cond-> (new-lib (->m data))
                eh-decorator (decorate+lib eh-decorator))))]
    (eci/new-component-factory {:lib f} component-factory)))
