/*
 * Copyright (c) 2018, FusionAuth, All Rights Reserved
 */
'use strict';

var FusionAuth = FusionAuth || {};
FusionAuth.Admin = FusionAuth.Admin || {};

/**
 * JavaScript for the manage user page.
 *
 * @constructor
 * @param userId {string} the user id.
 */
FusionAuth.Admin.ManageUser = function(userId) {
  Prime.Utils.bindAll(this);

  // Last Login table
  this.userId = userId;
  new FusionAuth.Admin.LastLogins(this.userId);

  this.tabs = new Prime.Widgets.Tabs(Prime.Document.queryFirst('.tabs'))
      .withErrorClassHandling('error')
      .withLocalStorageKey('manage-user')
      .initialize();

  // Ajax Dialogs in the header, Comment and Action.
  Prime.Document.query('.page-header [data-ajax-form="true"]').addEventListener('click', this._handleActionClick);

  // Ajax Dialogs in the Registrations and Group Memberships Table
  Prime.Document.query('#registrations [data-ajax-form="true"], #registrations [data-ajax-view="true"], #memberships [data-ajax-form="true"]')
      .addEventListener('click', this._handleActionClick);

  // Current Actions Table Row Actions
  Prime.Document.queryById('user-actions').query('[data-ajax-form="true"]').addEventListener('click', this._handleActionClick);

  // Panel Status Actions - Lock and Unlock
  Prime.Document.query('.panel-actions .status [data-ajax-form="true"]').addEventListener('click', this._handleActionClick);

  // JWT refresh token AJAX delete form
  Prime.Document.queryById('sessions').query('[data-ajax-form="true"]').addEventListener('click', this._handleActionClick);

  // Custom User Data
  new FusionAuth.Admin.UserData(Prime.Document.queryById('user-data')).initialize();
};

FusionAuth.Admin.ManageUser.constructor = FusionAuth.Admin.ManageUser;
FusionAuth.Admin.ManageUser.prototype = {

  /* ===================================================================================================================
   * Private Methods
   * ===================================================================================================================*/

  _handleActionUserDialogOpen: function() {
    new FusionAuth.Admin.UserActioningForm(Prime.Document.queryById('user-actioning-form'));
  },

  _handleActionClick: function(event) {
    Prime.Utils.stopEvent(event);
    var button = new Prime.Document.Element(event.currentTarget);
    var uri = button.getAttribute('href');

    if (uri.indexOf('/ajax/user/action') === -1 && uri.indexOf('/ajax/user/modify-action') === -1) {
      var formHandling = uri.indexOf("/view") === -1; // if this isn't a view ajax, it has a form
      new Prime.Widgets.AJAXDialog()
          .withFormHandling(formHandling)
          .withAdditionalClasses(button.is('[data-ajax-wide-dialog=true]') ? 'wide' : '')
          .open(uri);
    } else {
      new Prime.Widgets.AJAXDialog()
          .withFormHandling(true)
          .withCallback(this._handleActionUserDialogOpen)
          .withFormErrorCallback(this._handleActionUserDialogOpen)
          .withAdditionalClasses(button.is('[data-ajax-wide-dialog=true]') ? 'wide' : '')
          .open(uri);
    }
  }
};