/*
 * Copyright (c) 2018, FusionAuth, All Rights Reserved
 */
'use strict';

var FusionAuth = FusionAuth || {};
FusionAuth.Admin = FusionAuth.Admin || {};

/**
 * @constructor
 */
FusionAuth.Admin.TenantForm = function() {
  Prime.Utils.bindAll(this);

  this.form =  Prime.Document.queryById('tenant-form');
  this.addTenant = this.form.getAttribute('action') === '/admin/tenant/add';

  var tabs = Prime.Document.queryFirst('.tabs');
  if (tabs !== null) {
    new Prime.Widgets.Tabs(Prime.Document.queryFirst('.tabs'))
        .withErrorClassHandling('error')
        .withLocalStorageKey(this.addTenant ? null : 'tenant-configuration')
        .initialize();
  }
};

FusionAuth.Admin.TenantForm.prototype = {

  /* ===================================================================================================================
   * Private Methods
   * ===================================================================================================================*/

};
