(ns {{ns-name}}.events
  (:require-macros
    [cljs.core.async.macros :refer [go go-loop]]
    [plumbing.core :refer [defnk fnk letk fn-> fn->> if-letk]]
    [plumbing.map :refer [keyword-map]])
  (:require
    [ajax.core :as ajax]
    [de.elbenwald.common.utils :refer [->external-keys ->internal-keys to-camel-case]]
    [{{ns-name}}.queries :as queries]
    [de.elbenwald.app-common.utils :as acu]
    [medley.core :as m]
    [plumbing.core :refer [aconcat]]
    [re-frame.core :as rf]
    [re-frame.core :as rf]
    [re-graph.core :as rg]
    [reitit.core :as reitit]))

(def rules {"admin"  ["/"
                      "/about"
                      "/data"
                      "/logout"]})

;; dispatchers

(rf/reg-event-db
  :set-docs
  (fn [db [_ docs]]
    (assoc db :docs docs)))

(rf/reg-event-fx
  :fetch-docs
  (fn [_ _]
    {:http-xhrio {:method           :get
                  :uri              "/docs"
                  :response-format  (ajax/raw-response-format)
                  :on-success       [:set-docs]}}))

(rf/reg-event-db
  :common/set-error
  (fn [db [_ error]]
    (assoc db :common/error error)))

(rf/reg-event-db
  :fetch-user
  (fn [db _]
    (let [u (js->clj js/user :keywordize-keys true)
          user-uris (->> (:roles u)
                      (select-keys rules)
                      vals
                      aconcat
                      set)]
      (-> db
        (assoc :user u)
        (assoc :user-uris user-uris)))))

;; navigation

(rf/reg-event-db
  :navigate-start-page
  (fn [db [_ router]]
    (letk [[user] db
           start-page (-> user :start-page keyword)]
      (.log js/console "navigate-start-page" (pr-str start-page))
      (rf/dispatch [:navigate (reitit/match-by-name router start-page)]))
    db))

; FIXME use defmulti
(rf/reg-event-db
  :navigate
  (fn [db [_ route]]
    (.log js/console "navigate" (pr-str route))
    (let [page (-> route :data :name)
          args (-> route :path-params)]
      (case page

        :home
        (do
          (acu/set-on-load! "#home" #(rf/dispatch [:home/init])))

        :data
        (do
          (acu/set-on-load! "#data" #(rf/dispatch [:data/init]))
          (rf/dispatch [::rg/query
                        (queries/get-query :data/get-data)
                        (-> {} ->external-keys)
                        [:data/fetch-data]]))

        nil))

    (assoc db :route route)))

;
;
;

(rf/reg-event-db
  :on-app-event
  (fn [db [_ payload]]
    (letk [data (-> (.parse js/JSON payload)
                  (js->clj :keywordize-keys true)
                  :data
                  ->internal-keys)
           [event-data
            event-type] (get data :app-events)]
      (case event-type

        "session-expired"
        (do
          (acu/logout!))


        nil))
    db))

(rf/reg-event-db
  :home/init
  (fn [db _]
    (.log js/console (pr-str :init-home))
    db))

;; subscriptions

(rf/reg-sub
  :route
  (fn [db _]
    (-> db :route)))

(rf/reg-sub
  :page
  :<- [:route]
  (fn [route _]
    (-> route :data :name)))

(rf/reg-sub
  :docs
  (fn [db _]
    (:docs db)))

(rf/reg-sub
  :common/error
  (fn [db _]
    (:common/error db)))

(rf/reg-sub
  :user
  (fn [db _]
    (:user db)))

(rf/reg-sub
  :user-uris
  (fn [db _]
    (get-in db [:user-uris])))

(rf/reg-sub
  :navbar?
  (fn [db _]
    (get-in db [:user :navbar?])))
