(ns {{ns-name}}.env
  (:require
    [clojure.tools.logging :as l]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.io :as ecio]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.utils :refer :all]
    [{{ns-name}}.app :as app]
    [{{ns-name}}.incubator :as i]
    [plumbing.core :refer :all]))

(defnk make-component-factory
  "TODO doc"
  [:as env]
  (-> (eci/new-common-component-factory)
    (app/configure-app-factory {})
    (as-> $ (eci/new-component-factory {} $))))

(def defaults
  {:init
   (fn []
     (l/info "\n-=[{{ns-name}} started successfully using the {{profile}} profile]=-"))

   :stop
   (fn []
     (l/info "\n-=[{{ns-name}} has shut down successfully]=-"))

   :make-component-factory make-component-factory})
