(defproject {{project-name}} "0.1.0-SNAPSHOT"

  :description "Elbenwald {{name-short}}"
  :url "https://www.elbenwald.de"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :repositories [["releases" {:url "s3p://ew-tools/releases"
                              :creds :gpg}]
                 ["my.datomic.com" {:url "https://my.datomic.com/repo"
                                    :creds :gpg}]]

  :plugins [[s3-wagon-private "1.3.1" :exclusions [commons-logging]]
            [lein-cljsbuild "1.1.7"]]

  :dependencies [; common
                 [camel-snake-kebab "0.4.1"]
                 [clj-time "0.15.1"]
                 [com.taoensso/encore "2.109.0"]
                 [cprop "0.1.14"]
                 [me.raynes/fs "1.4.6"]
                 [medley "1.1.0"]
                 [orchestra "2018.12.06-2"]
                 [org.clojure/algo.monads "0.1.6"]
                 [org.clojure/clojure "1.10.1"]
                 [org.clojure/core.async "0.4.490"]
                 [org.clojure/core.match "0.3.0"]
                 [org.clojure/tools.logging "0.5.0"]
                 [prismatic/plumbing "0.5.5"]
                 [prismatic/schema "1.1.11"]
                 [proto-repl "0.3.1"]
                 [slingshot "0.12.2"]
                 [uncomplicate/fluokitten "0.9.1"]

                 ; project
                 [ch.qos.logback/logback-classic "1.3.0-alpha5"]
                 [mount "0.1.16"]
                 [nrepl "0.6.0"]
                 [org.clojure/tools.cli "0.4.2"]
                 [org.slf4j/log4j-over-slf4j "2.0.0-alpha1"]

                 ; libs
                 [de.elbenwald/common "0.25.0"]

                 ; conflicts
                 [org.clojure/tools.macro "0.1.5"]
                 [org.clojure/tools.namespace "0.3.0-alpha4"]]

  :min-lein-version "2.0.0"

  :jvm-opts []

  :resource-paths ["resources"]
  :source-paths ["src"]
  :target-path "target/%s/"
  :test-paths ["test"]

  :profiles
  {:provided {:dependencies []}

   :uberjar {:omit-source true
             :prep-tasks ["compile"]
             :aot :all
             :jar-name "_{{name-short}}-%s.jar"
             :uberjar-name "{{name-short}}-%s.jar"
             :source-paths ["env/prod/clj"]
             :resource-paths ["env/prod/resources"]}

   :dev           [:project/dev :profiles/dev]
   :test          [:project/dev :project/test :profiles/test]
   :midje         [:project/dev :project/test :project/midje :profiles/test]

   :project/dev  {:dependencies [[midje "1.9.8"]]
                  :jvm-opts ["-Dconf=dev-config.edn"]
                  :plugins [[lein-midje "3.2.1" :exclusions [org.clojure/clojure]]]
                  :repl-options {:init-ns user}
                  :resource-paths ["env/dev/resources"]
                  :source-paths ["env/dev/clj"]}
   :project/test {:jvm-opts ["-Dconf=test-config.edn"]
                  :resource-paths ["env/test/resources"]
                  :source-paths ["env/test/clj"]}
   :project/midje {}

   :profiles/dev {}
   :profiles/test {}

   :release {:release-tasks [["vcs" "assert-committed"]
                             ["change" "version" "leiningen.release/bump-version" "release"]
                             ["vcs" "commit"]]}
   :deploy {:release-tasks [["vcs" "assert-committed"]
                            ["vcs" "tag"]
                            ["deploy"]]}
                            ;["vcs" "push"] ; FIXME store ssh password
   :snapshot {:release-tasks [["vcs" "assert-committed"]
                              ["change" "version" "leiningen.release/bump-version"]
                              ["vcs" "commit"]]}}

  :release-tasks []
  :deploy-branches ["master"]

  :main ^:skip-aot {{ns-name}}.core)
