(ns {{ns-name}}.app
  (:require
    [clj-time.core :as t]
    [clojure.core.async :as a]
    [clojure.core.match :refer [match]]
    [clojure.spec.alpha :as s]
    [clojure.tools.logging :as l]
    [{{ns-name}}.incubator :as i]
    [{{ns-name}}.protocols :as p]
    [de.elbenwald.common.execution :as ece]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.io :as ecio]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.utils :refer :all]
    [de.elbenwald.security.utils :refer :all]
    [medley.core :as m]
    [orchestra.core :refer [defn-spec]]
    [orchestra.spec.test :as st]
    [plumbing.core :refer :all]
    [plumbing.graph :as g]
    [taoensso.encore :as e]
    [uncomplicate.fluokitten.core :as f]))

(defauthorized p/App p/AppBase eci/Service)

(def authorization-infos
  {:get-data
   (fn []
     (->authorization-info "ern:{{name-short}}:data"
                           "{{name-short}}:get-data"))

   :set-data
   (fn [value]
     (->authorization-info "ern:{{name-short}}:data"
                           "{{name-short}}:set-data"))

   :subscribe-events
   (fn [source target]
     (->authorization-info (format "ern:{{name-short}}:subscription/%s" source)
                           "{{name-short}}:subscribe"))})

;
; p/App
;

(defn get-data
  "TODO doc"
  [context]
  (letk [[app-data] context]
    @app-data))

(defn set-data
  "TODO doc"
  [context data]
  (letk [[app-data] context]
    (reset! app-data data)))

;
; p/AppBase
;

; FIXME move protocol and implementation to app-common

(defn handle-subscription-message
  "TODO doc"
  [context subscription-key message-data]
  (match [subscription-key]
    :else nil))

(defn session-id->topic
  "TODO doc"
  [session-id]
  (format "SESSION-%s" session-id))

(defnk app-events-topic-fn
  "TODO doc"
  [event-data
   event-type]
  (case event-type

    (:session-expired)
    (-> event-data
      :session-id
      session-id->topic)

    (:heartbeat)
    "ALL"))

(defn app-events-buf-fn
  "TODO doc"
  [topic]
  (cond

    (clojure.string/starts-with? topic "SESSION-")
    (a/buffer 10)

    :else
    (a/buffer 10000)))

(defn subscribe-events
  "TODO doc"
  [context source target]
  (letk [[events-pubs] context]
    (if-let [p (get events-pubs source)]
      (let [c (a/chan 10)]
        (case source
          "app"
          (let [topic (-> target session-id->topic)]
            (a/sub p topic c)
            (a/sub p "ALL" c)))
        c))))

;
; eci/Service
;

(defn get-service-status
  "TODO doc"
  [context opts]
  (l/debug "get-service-status: app" opts))

(defn start-service
  "TODO doc"
  [context]
  (letk [[] context]
    (l/debug "start-service: app")))

(defn stop-service
  "TODO doc"
  [context]
  (letk [[] context]
    (l/debug "stop-service: app")))

(defnew p/App p/AppBase eci/Service)

(defnk new-app
  "TODO doc"
  [app-events-ch]
  (letk [app-data (atom {:code :OK
                         :text "OK"})
         events-pubs {"app" (a/pub app-events-ch app-events-topic-fn app-events-buf-fn)}]
    (new+app+app-base+service (->m app-data
                                   events-pubs))))

(defdecorator p/App p/AppBase eci/Service)

(defn configure-app-factory
  "Adds an app factory
   to the given component factory."
  [component-factory options]
  (letk [f (fnk [app-events-ch
                 error-mode]
             (letk [eh-decorator (eci/get-eh-decorator error-mode :none)]
               (cond-> (new-app (->m app-events-ch))
                 eh-decorator (decorate+app+app-base+service eh-decorator eh-decorator eh-decorator))))]
    (eci/new-component-factory {:app f} component-factory)))
