(ns {{ns-name}}.global
  (:require
    [clojure.core.async :as a]
    [clojure.tools.logging :as l]
    [{{ns-name}}.app :as app]
    [{{ns-name}}.config :refer [env]]
    [{{ns-name}}.env :refer [defaults]]
    [{{ns-name}}.protocols :as p]
    [{{ns-name}}.routes.services.graphql :as graphql]
    [{{ns-name}}.scheduling :refer [make-scheduler-service]]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.io :as ecio]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.utils :refer :all]
    [de.elbenwald.security.protocols :as esp]
    [medley.core :as m]
    [mount.core :as mount]
    [plumbing.core :refer :all]
    [uncomplicate.fluokitten.core :as f]))

(defmulti handle-subscription-message
  "TODO doc"
  {:arglists '([subscription-key
                message])}
  (fn [subscription-key _] subscription-key))

(mount/defstate component-factory
  :start
  ((:make-component-factory defaults) env))

(mount/defstate timer
  :start
  (eci/CreateComponent component-factory
                       :timer
                       {:error-mode :either}))

(mount/defstate app-events-ch
  :start
  (a/chan 10000
          (map identity)
          #(l/error % "app-events-ch"))

  :stop
  (a/close! app-events-ch))

(mount/defstate app
  :start
  (letk [app (eci/CreateComponent component-factory
                                  :app
                                  (->m :error-mode :either
                                       app-events-ch))]
    (eci/StartService app)
    app)

  :stop
  (eci/StopService app))

(mount/defstate web-security
  :start
  (letk [[application-id
          authorization-rules] env

         access-logging (eci/CreateComponent component-factory
                                             :access-logging
                                             {:error-mode :either})
         authentication (eci/CreateComponent component-factory
                                             :authentication
                                             {:application-id application-id
                                              :error-mode :either})
         authorization (eci/CreateComponent component-factory
                                            :authorization
                                            {:error-mode :either
                                             :rules authorization-rules})]
    (eci/CreateComponent component-factory
                         :web-security
                         (->m :authorization-infos app/authorization-infos
                              :authorized-app app/authorized+app+app-base+service
                              :error-mode :either
                              access-logging
                              app
                              authentication
                              authorization))))

(mount/defstate graphql
  :start
  (eci/CreateComponent component-factory
                       :graphql
                       {:compiled-schema graphql/compiled-schema
                        :error-mode :either
                        :web-security web-security}))

(mount/defstate scheduler-service
  :start
  (let [scheduler-service (make-scheduler-service
                            {:app app
                             :name "scheduler-service"
                             :scheduling-infos (:scheduling-infos env)
                             :timeout-msec (* 5 1000)
                             :timer timer})]
    (eci/StartService scheduler-service)
    scheduler-service)

  :stop
  (eci/StopService scheduler-service))
