(ns {{ns-name}}.middleware
  (:require
    [cheshire.generate :as cheshire]
    [clojure.core.async :as a]
    [clojure.tools.logging :as l]
    [cognitect.transit :as transit]
    [{{ns-name}}.config :refer [env]]
    [{{ns-name}}.env :refer [defaults]]
    [{{ns-name}}.global :refer [app-events-ch]]
    [{{ns-name}}.i18n :refer [tconfig]]
    [{{ns-name}}.layout :refer [error-page]]
    [{{ns-name}}.middleware.formats :as formats]
    [immutant.web.middleware :refer [wrap-session]]
    [muuntaja.middleware :refer [wrap-format wrap-params]]
    [plumbing.core :refer :all]
    [ring-ttl-session.core :refer [ttl-memory-store]]
    [ring.middleware.anti-forgery :refer [wrap-anti-forgery]]
    [ring.middleware.defaults :refer [secure-site-defaults site-defaults wrap-defaults]]
    [ring.middleware.flash :refer [wrap-flash]]
    [ring.middleware.webjars :refer [wrap-webjars]]
    [taoensso.tempura :as tempura]))

(defn wrap-internal-error
  "TODO doc"
  [handler]
  (fn [req]
    (try
      (handler req)
      (catch Throwable t
        (l/error t (.getMessage t))
        (error-page {:status 500
                     :title "Something very bad has happened!"
                     :message "We've dispatched a team of highly trained gnomes to take care of the problem."})))))

(defn wrap-csrf
  "TODO doc"
  [handler]
  (wrap-anti-forgery handler
                     {:error-response
                      (error-page {:status 403
                                   :title "Invalid anti-forgery token"})}))

(defn wrap-i18n
  "TODO doc"
  [handler]
  (tempura/wrap-ring-request handler {:tr-opts tconfig}))

(defn wrap-formats
  "TODO doc"
  [handler]
  (let [wrapped (-> handler wrap-params (wrap-format formats/instance))]
    (fn [request]
      ;; disable wrap-formats for websockets
      ;; since they're not compatible with this middleware
      ((if (:websocket? request) handler wrapped) request))))

(defn wrap-base
  "TODO doc"
  [handler]
  (letk [[{ssl-options nil}] env
         [secure
          the-site-defaults] (if ssl-options
                               {:secure true
                                :the-site-defaults secure-site-defaults}
                               {:secure false
                                :the-site-defaults site-defaults})
         session-store-listener (fn [k v]
                                  (let [app-event {:event-data {:session-data v
                                                                :session-id k}
                                                   :event-type :session-expired}]
                                    (a/go (a/>! app-events-ch app-event))))]
    (-> ((:middleware defaults) handler)
      wrap-webjars
      (wrap-defaults (-> the-site-defaults
                       (assoc-in [:security :anti-forgery] false)
                       (assoc-in [:security :content-type-options] :nosniff)
                       (assoc-in [:session :store] (ttl-memory-store 5
                                                                     {:listeners [session-store-listener]
                                                                      :time-unit :minutes}))))
      wrap-flash
      (wrap-session {:cookie-attrs {:http-only true
                                    :secure secure}})
      wrap-internal-error)))
