(ns {{ns-name}}.routes.home
  (:require
    [clojure.java.io :as jio]
    [{{ns-name}}.global :refer [web-security]]
    [{{ns-name}}.incubator :as i]
    [{{ns-name}}.layout :as layout]
    [{{ns-name}}.middleware :as middleware]
    [{{ns-name}}.protocols :as p]
    [{{ns-name}}.utils :as u]
    [{{ns-name}}.utilsc :as uc]
    [de.elbenwald.app-common.pages.login :as login]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.io :as ecio]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.utils :refer :all]
    [de.elbenwald.security.protocols :as esp]
    [de.elbenwald.security.utils :refer :all]
    [hiccup.core :refer [html]]
    [ring.util.http-response :as response]))

(defn graphiql-page
  "TODO doc"
  [request]
  (layout/render request "graphiql.html"))

(defn home-page
  "TODO doc"
  [request params]
  (layout/render request "home.html" params))

(defn login-page
  [request]
  (layout/render request
                 "login.html"
                 {:title "Login"
                  :content (-> (login/page) html)}))

(defn home-routes []
  [""
   {:middleware [middleware/wrap-csrf
                 middleware/wrap-formats]}

   ["/"
    {:get (fn [request]
            (with-wui-authentication web-security
              (let [user-options (->m :navbar? true
                                      :start-page "home")
                    user (merge user user-options)]
                (home-page request (->m user)))))}]

   ["/login"
    {:get (fn [request]
            (login-page request))
     :post (fn [request]
             (esp/HandleRequest web-security :login-post request))}]

   ["/logout"
    {:get (fn [request]
            (esp/HandleRequest web-security :logout-get request))}]

   ["/docs"
    {:get (fn [request]
            (with-wui-authentication web-security
              (-> "docs/docs.md" jio/resource slurp
                response/ok
                (response/header "Content-Type" "text/plain; charset=utf-8"))))}]

   ["/graphiql"
    {:get (fn [request]
            (with-wui-authentication web-security
              (graphiql-page request)))}]

   ["/health"
    {:get (fn [request]
            (-> "ok"
              response/ok
              (response/header "Content-Type" "text/plain; charset=utf-8")))}]])
