/*
 * Decompiled with CFR 0.152.
 */
package elephantdb.cascading;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.Identity;
import cascading.pipe.Each;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import elephantdb.Utils;
import elephantdb.cascading.Common;
import elephantdb.cascading.ElephantDBTap;
import elephantdb.persistence.LocalPersistenceFactory;
import java.util.UUID;
import org.apache.hadoop.io.BytesWritable;

public class ElephantTailAssembly
extends SubAssembly {
    public ElephantTailAssembly(Pipe pipe, ElephantDBTap elephantDBTap) {
        String string = "shard" + UUID.randomUUID().toString();
        String string2 = "keysort" + UUID.randomUUID().toString();
        Each each = new Each(pipe, new Fields(new Comparable[]{Integer.valueOf(0)}), (Function)new Shardize(string, elephantDBTap.getSpec().getNumShards()), Fields.ALL);
        each = new Each((Pipe)each, new Fields(new Comparable[]{Integer.valueOf(0)}), (Function)new MakeSortableKey(string2, elephantDBTap.getSpec().getLPFactory()), Fields.ALL);
        each = new Each((Pipe)each, new Fields(new Comparable[]{Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(3)}), (Function)new Identity(), Fields.RESULTS);
        each = new GroupBy((Pipe)each, new Fields(new Comparable[]{Integer.valueOf(0)}), new Fields(new Comparable[]{Integer.valueOf(3)}));
        each = new Each((Pipe)each, new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)}), (Function)new Identity());
        this.setTails(new Pipe[]{each});
    }

    public static class MakeSortableKey
    extends BaseOperation
    implements Function {
        LocalPersistenceFactory _fact;

        public MakeSortableKey(String string, LocalPersistenceFactory localPersistenceFactory) {
            super(new Fields(new Comparable[]{string}));
            this._fact = localPersistenceFactory;
        }

        public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
            byte[] byArray = Common.serializeElephantVal(functionCall.getArguments().get(0));
            byte[] byArray2 = this._fact.getKeySorter().getSortableKey(byArray);
            functionCall.getOutputCollector().add(new Tuple(new Object[]{new BytesWritable(byArray2)}));
        }
    }

    public static class Shardize
    extends BaseOperation
    implements Function {
        int _numShards;

        public Shardize(String string, int n) {
            super(new Fields(new Comparable[]{string}));
            this._numShards = n;
        }

        public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
            Comparable comparable = functionCall.getArguments().get(0);
            byte[] byArray = Common.serializeElephantVal(comparable);
            int n = Utils.keyShard((byte[])byArray, (int)this._numShards);
            functionCall.getOutputCollector().add(new Tuple(new Object[]{n}));
        }
    }
}

