(ns embelyon.codex.impl.specification.spec
  (:require [clojure.spec.alpha :as s]))

;;; AWS Types

(def primitives #{"String" "Boolean" "Double" "Integer" "Long" "Timestamp" "Json"})

(s/def ::Documentation string?)

(s/def ::ItemType string?)

(s/def ::PrimitiveItemType primitives)

(s/def ::PrimitiveType primitives)

(s/def ::Type (s/or :list #{"List"} :property string?))

(s/def ::attribute (s/or
                     :complex   (s/keys :req-un [::Type ::ItemType])
                     :primitive (s/keys :req-un [::PrimitiveType ::PrimitiveItemType])))

(s/def ::Attributes (s/map-of keyword? ::attribute))

(s/def ::DuplicatesAllowed #{true false})

(s/def ::Required #{true false})

(s/def ::UpdateType #{"Mutable" "Immutable" "Conditional"})

(s/def ::property (s/or
                    :complex   (s/keys :req-un [::Documentation ::UpdateType (or ::Type ::ItemType)]
                                       :opt-un [::DuplicatesAllowed])
                    :primitive (s/keys :req-un [::Documentation ::UpdateType (or ::PrimitiveType ::PrimitiveItemType)]
                                       :opt-un [::DuplicatesAllowed])))

(s/def ::Properties (s/map-of keyword? ::property))

(s/def ::resource (s/keys :req-un [::Documentation ::Properties]
                          :opt-un [::Attributes]))

(s/def ::property-type (s/keys :req-un [::Documentation ::Properties]))

(s/def ::PropertyTypes (s/map-of keyword? ::property-type))

(s/def ::ResourceTypes (s/map-of keyword? ::resource))

(s/def ::ResourceSpecificationVersion string?)

(s/def ::cloud-formation-spec (s/keys :req-un [::PropertyTypes ::ResourceTypes ::ResourceSpecificationVersion]))

;;; Lore types

(s/def ::name string?)

(s/def ::resources ::ResourceTypes)

(s/def ::service (s/keys :req-un [::name ::resources]))

(def regions
  #{:us-east-1
    :us-east-2
    :us-west-1
    :us-west-2
    :ap-south-1
    :ap-northeast-3
    :ap-northeast-2
    :ap-northeast-1
    :ap-southeast-1
    :ap-southeast-2
    :ca-central-1
    :cn-north-1
    :cn-northwest-1
    :eu-central-1
    :eu-west-1
    :eu-west-2
    :eu-west-3
    :sa-east-1
    :us-gov-east-1
    :us-gov-west-1})

(s/def ::region regions)
