(ns embelyon.seer.doc.spec
  (:require [clojure.spec.alpha :as s]))

(s/def ::url string?)

(s/def ::title string?)

(s/def ::description (s/coll-of string?))

(s/def ::term string?)

(s/def ::definition (s/coll-of string?))

(s/def ::variable (s/keys :req [::term ::definition]))

(s/def ::properties (s/coll-of ::variable))

(s/def ::section (s/cat :heading string? :details (s/+ string?)))

(s/def ::ref ::section)

(s/def ::getatt ::section)

(s/def ::returns (s/coll-of ::variable))

(s/def ::view (s/keys :req [::url ::title ::description ::properties ::ref ::getatt ::returns]))

(s/def ::node any?) ;;; not going to sweat this detail

(s/def ::doc (s/coll-of ::node))

(s/def ::parse-input (s/cat :doc ::doc  :slug string? :url string?))
