(defproject employeerepublic/er-model "0.1.1-SNAPSHOT"
  :description "ER backend model access"
  :url "https://bitbucket.org/employeerepublic/er-model"
  :dependencies [[org.clojure/clojure "1.7.0"]

                 [org.clojure/tools.logging "0.3.1"]
                 [ch.qos.logback/logback-classic "1.1.3"]
                 [org.slf4j/slf4j-api "1.7.12"]
                 [org.slf4j/jcl-over-slf4j "1.7.12"]
                 [org.slf4j/log4j-over-slf4j "1.7.12"]
                 [org.slf4j/jul-to-slf4j "1.7.12"]

                 [com.taoensso/timbre "4.1.1"]
                 [prismatic/plumbing "0.5.0"]
                 [prismatic/schema "1.0.1"]
                 [danlentz/clj-uuid "0.1.6"]
                 [clj-time "0.10.0"]
                 [buddy "0.7.1" :exclusions [funcool/cats]]
                 [environ "1.0.0"]
                 [jarohen/embed-nrepl "0.1.1"]

                 [jarohen/yoyo "0.0.5"]
                 [jarohen/yoyo.system "0.0.1"]
                 [yoyo.closeable "0.0.3"]

                 [employeerepublic/er-cassandra "0.5.5"]]

  :plugins [[lein-environ "1.0.0"]]

  :profiles {:dev {:dependencies []
                   :resource-paths ["dev-resources"]
                   :plugins [[drift "1.5.3" :exclusions [org.clojure/clojure]]]}}

  :main ^:skip-aot er-model.system
  )
