(ns er-model.conversations.schema
  (:require
   [plumbing.core]
   [schema.core :as s #?@(:cljs [:include-macros true])]
   [schema.coerce :refer [coercer]]
   [er-model.schema :refer [x-json-coercion-matcher]]))

(def ConversationSchema
  {:org_id s/Uuid
   :id s/Uuid
   :name (s/maybe s/Str)
   :type s/Str
   :participant_ids #{s/Uuid}})

(def conversation-schema-coercer
  (coercer ConversationSchema x-json-coercion-matcher))

(def ConversationMessageSchema
  {:org_id s/Uuid
   :conversation_id s/Uuid
   :message_time s/Inst
   :id s/Uuid
   :author_id s/Uuid
   :body s/Str
   :type s/Str})

(def conversation-message-schema-coercer
  (coercer ConversationMessageSchema x-json-coercion-matcher))

(def RecentConversationSchema
  {:org_id s/Uuid
   :user_id s/Uuid
   :conversation_id s/Uuid
   :conversation_type s/Str

   :last_message_id s/Uuid
   :last_message_author_id s/Uuid
   :last_message_time s/Inst
   :last_message_body s/Str})

(def recent-conversation-schema-coercer
  (coercer RecentConversationSchema x-json-coercion-matcher))
