(ns er-model.groups.schema
  (:require
   [plumbing.core]
   [schema.core :as s #?@(:cljs [:include-macros true])]
   [schema.coerce :refer [coercer]]
   [er-model.schema :refer [x-json-coercion-matcher]]))

(def GroupSchema
  {:org_id s/Uuid
   :id s/Uuid
   :name s/Str
   :sort_name s/Str
   :updated_at (s/maybe s/Inst)
   :visibility s/Str
   :join_policy s/Str
   :profile_text (s/maybe s/Str)
   :profile_pic_url (s/maybe s/Str)
   :search_key #{s/Str}})

(def ClientGroupSchema
  (-> GroupSchema
      (assoc :id (s/maybe s/Uuid))
      (dissoc GroupSchema :search_key)))

(def client-group-schema-coercer
  (coercer ClientGroupSchema x-json-coercion-matcher))

(def UserIdsSchema
  {:user_ids #{s/Uuid}})

(def GroupWithUserIdsSchema
  (merge GroupSchema
         UserIdsSchema))

(def ClientGroupWithUserIdsSchema
  (merge ClientGroupSchema
         UserIdsSchema))

(def UserGroupSchema
  {:org_id s/Uuid
   :user_id s/Uuid
   :group_id s/Uuid
   :group_name s/Str
   :group_search_key #{s/Str}
   :group_sort_name s/Str})

(def user-group-schema-coercer
  (coercer UserGroupSchema x-json-coercion-matcher))
