(ns er-model.migrations-cassandra.20150825130631-create-org-users
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150825130631."
  []
  (println "er-model.migrations-cassandra.20150825130631-create-org-users up...")
  (execute
   "create table org_users (org_id timeuuid,
                            user_id timeuuid,
                            username text,
                            updated_at timestamp,
                            auth_role set<text>,
                            search_key set<text>,
                            name text,
                            sort_name text,
                            phone_no text,
                            location text,
                            role text,
                            skill list<text>,
                            profile_text text,
                            profile_pic_url text,
                            primary key ((org_id), user_id))"))

(defn down
  "Migrates the database down from version 20150825130631."
  []
  (println "er-model.migrations-cassandra.20150825130631-create-org-users down...")
  (execute
   "drop table org_users"))
