(ns er-model.migrations-cassandra.20150825131005-create-groups
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150825131005."
  []
  (println "er-model.migrations-cassandra.20150825131005-create-groups up...")
  (execute
   "create table groups (org_id timeuuid,
                         id timeuuid,
                         visibility text,
                         join_policy text,
                         search_key set<text>,
                         name text,
                         sort_name text,
                         updated_at timestamp,
                         profile_text text,
                         profile_pic_url text,
                         primary key (org_id, id))"))

(defn down
  "Migrates the database down from version 20150825131005."
  []
  (println "er-model.migrations-cassandra.20150825131005-create-groups down...")
  (execute
   "drop table groups"))
