(ns er-model.migrations-cassandra.20150825131325-create-user-groups
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150825131325."
  []
  (println "er-model.migrations-cassandra.20150825131325-create-user-groups up...")
  (execute
   "create table user_groups (org_id timeuuid,
                              user_id timeuuid,
                              group_id timeuuid,
                              group_name text,
                              group_sort_name text,
                              group_search_key set<text>,
                              primary key ((org_id, user_id), group_id))"))

(defn down
  "Migrates the database down from version 20150825131325."
  []
  (println "er-model.migrations-cassandra.20150825131325-create-user-groups down...")
  (execute
   "drop table user_groups"))
