(ns er-model.migrations-cassandra.20150825131507-create-conversation-participants
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150825131507."
  []
  (println "er-model.migrations-cassandra.20150825131507-create-conversation-participants up...")
  (execute
   "create table conversation_participants
      (org_id timeuuid,
       conversation_type text,
       conversation_id uuid,
       participant_id timeuuid,
       updated_at timestamp,
       mute map<text, boolean>,
       last_seen_message_id timeuuid,
       last_seen_message_time timestamp,
       primary key ((org_id, conversation_id),participant_id))"))

(defn down
  "Migrates the database down from version 20150825131507."
  []
  (println "er-model.migrations-cassandra.20150825131507-create-conversation-participants down...")
  (execute
   "drop table conversation_participants"))
