(ns er-model.migrations-cassandra.20150825131656-create-conversation-messages
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150825131656."
  []
  (println "er-model.migrations-cassandra.20150825131656-create-conversation-messages up...")
  (execute
   "create table conversation_messages
      (org_id timeuuid,
       conversation_id uuid,
       message_time timestamp,
       id timeuuid,
       type text,
       author_id timeuuid,
       body text,
       primary key ((org_id, conversation_id), message_time, id))
       with clustering order by (message_time desc, id asc)"))

(defn down
  "Migrates the database down from version 20150825131656."
  []
  (println "er-model.migrations-cassandra.20150825131656-create-conversation-messages down...")
  (execute
   "drop table conversation_messages"))
