(ns er-model.migrations-cassandra.20150825131745-create-poll-conversations
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150825131745."
  []
  (println "er-model.migrations-cassandra.20150825131745-create-poll-conversations up...")
  (execute
   "create table poll_conversations
      (org_id timeuuid,
       conversation_id uuid,
       poll_type text,
       poll_time timestamp,
       owner_id timeuuid,
       completed boolean,
       yes counter,
       no counter,
       primary key ((org_id, conversation_id), poll_type, poll_time, owner_id, completed))
      with clustering order by (poll_type asc, poll_time desc, owner_id asc, completed asc)"))

(defn down
  "Migrates the database down from version 20150825131745."
  []
  (println "er-model.migrations-cassandra.20150825131745-create-poll-conversations down...")
  (execute
   "drop table poll_conversations"))
