(ns er-model.migrations-cassandra.20150909132343-create-addressee-conversations
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150909132343."
  []
  (println "er-model.migrations-cassandra.20150909132343-create-addressee-conversations up...")
  (execute
   "create table addressee_conversations
      (org_id timeuuid,
       conversation_type text,
       conversation_id uuid,
       addressee_type text,
       addressee_id timeuuid,
       primary key ((org_id, addressee_id, conversation_type), conversation_id))"))

(defn down
  "Migrates the database down from version 20150909132343."
  []
  (println "er-model.migrations-cassandra.20150909132343-create-addressee-conversations down...")
  (execute
   "drop table conversation_addressees"))
