(ns er-model.migrations-cassandra.20150910143232-create-groups-by-visibility-name
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150910143232."
  []
  (println "er-model.migrations-cassandra.20150910143232-create-groups-by-visibility-name up...")
  (execute
   "create table groups_by_visibility_sort_name
      (org_id timeuuid,
       id timeuuid,
       visibility text,
       sort_name text,
       primary key ((org_id, visibility), sort_name, id))"))

(defn down
  "Migrates the database down from version 20150910143232."
  []
  (println "er-model.migrations-cassandra.20150910143232-create-groups-by-visibility-name down...")
  (execute
   "drop table groups_by_visibility_sort_name"))
