(ns er-model.migrations-cassandra.20150912102525-add-conversation-id-index-to-user-recent-migrations
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]
            [er-cassandra.schema :refer [table-metadata]]))

(defn up
  "Migrates the database up to version 20150912102525."
  []
  (println "er-model.migrations-cassandra.20150912102525-add-conversation-id-index-to-user-recent-migrations up...")
  @(table-metadata (session) (:keyspace (session)) "user_recent_conversations_conversation_id_idx")
  (println "waiting for a bit...")
  (Thread/sleep 5000)
  (execute
   "create index user_recent_conversations_conversation_id_idx
    on user_recent_conversations (conversation_id)"))

(defn down
  "Migrates the database down from version 20150912102525."
  []
  (println "er-model.migrations-cassandra.20150912102525-add-conversation-id-index-to-user-recent-migrations down...")
  (execute "drop index user_recent_conversations_conversation_id_idx"))
