(ns er-model.migrations-cassandra.20150920223832-create-org-users-by-search-key
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150920223832."
  []
  (println "er-model.migrations-cassandra.20150920223832-create-org-users-by-search-key up...")
  (execute
   "create table org_users_by_search_key
      (org_id timeuuid,
       user_id timeuuid,
       search_key text,
       primary key ((org_id), search_key, user_id))"))

(defn down
  "Migrates the database down from version 20150920223832."
  []
  (println "er-model.migrations-cassandra.20150920223832-create-org-users-by-search-key down...")
  (execute
   "drop table org_users_by_search_key"))
