(ns er-model.migrations-cassandra.20150926194900-create-user-groups-by-group-search-key
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150926194900."
  []
  (println "er-model.migrations-cassandra.20150926194900-create-user-groups-by-group-search-key up...")
  (execute
   "create table user_groups_by_group_search_key
      (org_id timeuuid,
       user_id timeuuid,
       group_id timeuuid,
       group_search_key text,
       primary key ((org_id, user_id), group_search_key, group_id))"))

(defn down
  "Migrates the database down from version 20150926194900."
  []
  (println "er-model.migrations-cassandra.20150926194900-create-user-groups-by-group-search-key down...")
  (execute
   "drop table user_groups_by_group_search_key"))
