(ns er-model.migrations-cassandra.20150926212127-create-groups-by-visibility-search-key
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150926212127."
  []
  (println "er-model.migrations-cassandra.20150926212127-create-groups-by-visibility-search-key up...")
  (execute
   "create table groups_by_visibility_search_key
      (org_id timeuuid,
       id timeuuid,
       visibility text,
       search_key text,
       primary key ((org_id, visibility), search_key, id))"))

(defn down
  "Migrates the database down from version 20150926212127."
  []
  (println "er-model.migrations-cassandra.20150926212127-create-groups-by-visibility-search-key down...")
  (execute
   "drop table groups_by_visibility_search_key"))
