(ns clj-vw.online.nio
  (:require
    [clojure.set :as set]
    [clojure.string :as string]
    [clojure.tools.logging :refer :all]
    [clojure.core.async :refer [>!! <!! chan close! go <! >! thread timeout alt!]])
  (:import
    [java.util UUID]
    [java.nio  ByteBuffer]
    [java.io   IOException]
    [java.net  InetSocketAddress StandardSocketOptions]
    [java.nio.channels Selector SelectionKey ServerSocketChannel SocketChannel SelectableChannel ClosedChannelException]))

;;; 1) create a selector

(def s (Selector/open))

;;; 2) create a non-blocking socket channel

(def addr (inet-addr {:host "localhost" :port 26542}))
(def sc (doto (SocketChannel/open)
          (.configureBlocking false)
          (.connect addr)))

;;; 3) register channel for op_connect

()






;;;; 1) open a socket channel

(def sc (SocketChannel/open))
(.configureBlocking sc false)
(.connect sc (inet-addr {:host "127.0.0.1" :port 26542}))
(.finishConnect sc)

;;;; 2) send msg
(def newData "1 | a b\n")
(def buf (ByteBuffer/allocate 48))
(.clear buf)
(.put buf (.getBytes newData))

(.flip buf)
(while (.hasRemaining buf)
  (.write sc buf))

;;; 3) read response
;; (def buf (ByteBuffer/allocate 4))
(.clear buf)
(.read sc buf) ;; 9 Yihaa!
(map char (.array buf))

;; (.close sc)
;; (.limit buf)
;; (.position buf)
;; (.capacity buf)



;;; 4) selectors

(def s (Selector/open))
(def sc (SocketChannel/open))
(.configureBlocking sc false)
(.register sc s, SelectionKey/OP_WRITE)




(.select s)
(def k (first (.selectedKeys s)))

(.isAcceptable k)
(.isConnectable k)
(.isReadable k)  ;; true
(.isWritable k)

(= sc (.channel k))



(apply str (map char [48, 46, 48, 48, 48, 48, 48, 48, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]))
(apply str (map char [48, 46, 53, 55, 57, 50, 57, 49, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0]))
[48, 46, 56, 49]
[48, 54, 49, 52]
[10, 54, 49, 52]
(char 10)
(apply str (map char [48, 46, 56, 54, 51, 57, 50, 57, 10, 48, 46, 57, 52, 56, 52, 49, 50,
 10, 48, 46, 57, 55, 57, 51, 49, 49, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]))

;; writing: use a buffer of required length
;; reading: read characters => character stream
;; character-stream => break on newline 

;; char-channel: characters read from socket channel
;; => bufffer of B, loop 

;; SOCKET CALLBACKS

