(ns cloverage.report.gitlabci
  (:gen-class)
  (:require
   [clojure.string :as cs]
   [cloverage.report :refer [file-stats total-stats]]))

(defn report
  "Create a text summary for output on the command line"
  [forms]
  (let [totalled-stats (total-stats forms)
        all-forms-pct (:percent-forms-covered totalled-stats)
        all-lines-pct (:percent-lines-covered totalled-stats)]

    (println "=============================== Coverage summary ===============================");
    (println (str "Statements   : " (format "%.2f" all-forms-pct) "%"))
    (println (str "Lines        : " (format "%.2f" all-lines-pct) "%"))
    (println "================================================================================")))
