(ns blueprint.client.url
  (:require [clojure.spec.alpha :as s]))

;; (ns-unmap *ns* 'resolve-endpoint)
(defmulti ^{:private true} -resolve-endpoint (fn [[t _] arg] t))
(defmethod -resolve-endpoint :string [[_ path] arg] path)
(defmethod -resolve-endpoint :arg [[_ {attr :name :as elem}] arg] (get arg attr))

(defn cmd->request
  "Given a blueprint `command` definition and an `input`, returns a map describing an http request"
  [{input :input params :params {elems :elems method :method} :path :as cmd}
   arg]
  (let [url   (reduce str (map #(-resolve-endpoint % arg) elems))
        parms (select-keys arg (map keyword (keys params)))]
    (cond-> {:url            url
             :request-method method}
      input (assoc :body arg)
      params (assoc :query-params parms))))

(comment
  (def cmd '{:path   {:method :get
                      :elems  ([:string "/job/"]
                               [:arg {:name :id, :def {:type :pred, :pred uuid?}}])}
             :params {company string?}})
  (cmd->request cmd {:id (java.util.UUID/randomUUID) :company "x"})
  "end")


