(ns blueprint.core
  (:require [clojure.edn        :as edn]
            [clojure.java.io    :as io]
            [blueprint.registry :as reg]
            [blueprint.spec-gen :as sg]))

(defn parse
  [source]
  (-> source
      (reg/build)
      (sg/generate-specs)))

(defn spec-for
  [api-def k]
  (-> api-def :specs (get k)))

(def resource-spec #'spec-for)
(def command-spec #'spec-for)

(defn handler-spec
  [api-def]
  (spec-for api-def :handler))
