(ns blueprint.core
  (:require [blueprint.registry :as reg]
            blueprint.spec
            [blueprint.spec-gen :as sg]))

(def parse
  (memoize
   (fn parse' [source]
     (-> source
         (reg/build)
         (sg/generate-specs!)
         (assoc :parsed? true)))))

(defn resource-spec
  [ns k]
  (keyword (format "%s.resource"
                   (name ns))
           (name k)))

(defn- command-spec
  [ns k scope]
  (keyword (format "%s.command.%s"
                   (name ns)
                   (name k))
           scope))

(defn command-output-spec
  [ns k]
  (command-spec ns k "output"))

(defn command-input-spec
  [ns k]
  (command-spec ns k "input"))

(defn command-params-spec
  [ns k]
  (command-spec ns k "params"))

(defn command-path-spec
  [ns k]
  (command-spec ns k "path"))

(defn command-handler-spec
  [ns k]
  (command-spec ns k "handler"))
