(ns blueprint.handler.request-id
  ""
  (:require [clojure.spec.alpha :as s])
  (:import java.util.UUID))

(defn add-to-headers
  [exposed-id-header ctx]
  (assoc-in ctx [:response :headers exposed-id-header] (:request-id ctx)))

(defn request-id-builder
  [this {:blueprint.handler/keys [id-generator  exposed-id-header]}]
  (let [id-gen (or id-generator #(java.util.UUID/randomUUID))]
    (cond-> (assoc this :enter #(assoc % :request-id (id-gen)))
      (some? exposed-id-header)
      (assoc :leave (partial add-to-headers exposed-id-header)))))

(def interceptor
  "An interceptor which adds a request ID, by default generates a random UUID
   accepts `:blueprint.handler/id-generator` in configuration, a 0-arity
   function to produce request IDs"
  {:name    :blueprint.handler/request-id
   :builder request-id-builder
   :spec    ::request-id})

(s/def ::request-id (s/keys :opt [:blueprint.handler/id-generator]))
(s/def :blueprint.handler/id-generator ifn?)
