(defproject exoscale/blueprint-handler "0.2.44"

  :plugins [[lein-parent "0.3.8"]]

  :parent-project {:path "../../project.clj"
                   :inherit [:managed-dependencies
                             :license
                             :url
                             :scm
                             :deploy-repositories
                             :pedantic?
                             :description]}

  :dependencies [[org.clojure/clojure]
                 [org.clojure/tools.logging]
                 [exoscale/ex]
                 [exoscale/interceptor]
                 [spootnik/aleph-params]
                 [metosin/muuntaja]
                 [metosin/jsonista]
                 [com.fasterxml.jackson.core/jackson-databind]
                 [com.fasterxml.jackson.core/jackson-core]
                 [com.fasterxml.jackson.datatype/jackson-datatype-jsr310]
                 [metosin/spec-tools]
                 [exoscale/cloak]
                 [manifold]
                 [expound]]
  :profiles {:dev  {:dependencies   [[exoscale/blueprint-core]
                                     [exoscale/blueprint-openapi]
                                     [exoscale/blueprint-router]
                                     [commons-codec]
                                     [ring/ring-mock
                                      :exclusions [ring/ring-codec]]]
                    :resource-paths ["dev/resources"]}
             :test {
                    :resource-paths ["test/resources"]}})
