(defproject exoscale/blueprint "0.1.3"

  :description "Data definitions for APIs"
  :plugins [[lein-modules "0.3.11"]
            [lein-codox   "0.10.7"]]

  :profiles {:provided {:dependencies [[org.clojure/clojure _]]}
             :dev      {:dependencies [[spootnik/unilog _]]}}

  :scm {:name "git" :url "https://github.com/exoscale/blueprint"}

  :modules {:versions {org.clojure/clojure       "1.10.1"
                       org.clojure/tools.logging "0.5.0"
                       exoscale/interceptor      "0.1.7"
                       exoscale/ex               "0.3.6"
                       spootnik/unilog           "0.7.24"
                       spootnik/aleph-params     "0.1.2"
                       metosin/spec-tools        "0.10.0"
                       metosin/jsonista          "0.2.5"
                       metosin/muuntaja          "0.6.5"
                       metosin/reitit-core       "0.3.10"
                       camel-snake-kebab         "0.4.0"
                       expound                   "0.7.2"
                       aleph                     "0.4.7-alpha5"

                       exoscale/blueprint-core    :version
                       exoscale/blueprint-openapi :version
                       exoscale/blueprint-handler :version
                       exoscale/blueprint-router  :version}
            :subprocess nil
            :inherited  {:license                  {:name "MIT/ISC"}
                         :url                      "https://github.com/exoscale/blueprint"
                         :scm                      {:name "git" :url "https://github.com/exoscale/blueprint"}
                         :deploy-repositories      [["releases" :clojars] ["snapshots" :clojars]]
                         :pedantic? :warn
                         :monkeypatch-clojure-test false}}

  :dependencies [[exoscale/blueprint-core    :version]
                 [exoscale/blueprint-openapi :version]
                 [exoscale/blueprint-router  :version]
                 [exoscale/blueprint-handler :version]]

  :release-tasks [["modules" "test"]
                  ["vcs" "assert-committed"]
                  ["modules" "change" "version" "leiningen.release/bump-version" "release"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "--no-sign"]
                  ["modules" "install"]
                  ["modules" "deploy"]
                  ["deploy"]
                  ["modules" "change" "version" "leiningen.release/bump-version"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]

  :codex {:source-uri "https://github.com/exoscale/blueprint/blob/{version}/{filepath}#L{line}"
          :doc-files ["README.md"]
          :metadata {:doc/format :markdown}
          :source-paths ["modules/core/src"
                         "modules/openapi/src"
                         "modules/router/src"
                         "modules/handler/src"]})
