blueprint: data definitions for APIs
====================================

```clojure
   [exoscale/blueprint-server  "0.2.2"]
```

Blueprint aims to simplify the creation of API servers and clients in
Clojure.

### Canonical use-case

The APIs blueprint optimizes for are APIs that are network I/O bound.
These are typically APIs *at the edge* which bridge together elements
coming from internal services. This canonical use-case instructed the
following design constraints on blueprint:

- Departing from requests in a synchronously to avoid hogging threads
  waiting for network I/O
- Preventing the use of IDL-based environments which are not suited
  for external consumption

To do this, blueprint relies on two essential foundations:

- A data language to describe API commands and resources
- Support for mapping API commands to handler functions

Under the covers, blueprint glues together a few foundational
components:

- A data specification, validation, and coercion library. The library
  ergonomics was inspired by [malli](https://github.com/metosin/malli)
  but retains compatibility with `clojure.spec`. See below for the
  rationale behind this library.
- Asynchronous programming, and asynchronous network I/O with
  [manifold](https://github.com/ztellman/manifold) and
  [aleph](https://github.com/ztellman/aleph)
- Flexible request lifecycle and error handling with
  [interceptor](https://github.com/exoscale/interceptor) and
  [ex](https://github.com/exoscale/ex)
- OpenAPI export support for easy polyglot client library building

By default, blueprint will perform request routing, content negotiation,
data validation and coercion before reaching a provided command handler,
ensuring only proper data is handed out to handler. For an exhaustive
list of default helpers, please refer to the description of
[default interceptors](doc/default-interceptors.md#default-interceptor-chain)

Conversely, blueprint API clients will perform the same validation on
sent payloads are received responses.

The following documents provide a deep dive into the essential parts
of blueprint:

- [Data specs language and resource definitions](doc/data-spec.md)
- [Command description](doc/commands.md)
- [Additional attributes](doc/attributes.md)
- [Request lifecycle handling with interceptors](doc/interceptors.md)
- [Error handling](doc/error.md)
- [OpenAPI spec generation](doc/openapi.md)
- [Building dispatch maps](doc/dispatch-map.md)
