(ns exoscale.checkmate.core-async
  (:require [clojure.core.async :as async]
            [exoscale.checkmate.condition :as c]
            [exoscale.checkmate.impl :as impl]))

(defn- ^:no-doc effects!
  [proto f conditions state]
  (async/go
    (doseq [cd conditions]
      (when (satisfies? proto cd)
        (async/<! (f cd state)))
      conditions)))

(def ^:no-doc setup-effects! (partial effects! c/SetupEffect #'c/setup-effect!))
(def ^:no-doc error-effects! (partial effects! c/ErrorEffect #'c/error-effect!))
(def ^:no-doc failure-effects! (partial effects! c/FailureEffect #'c/failure-effect!))
(def ^:no-doc success-effects! (partial effects! c/SuccessEffect #'c/success-effect!))

(defn run
  "Same as sync-runner but returns a promise channel, Effects are
  assumed to return channels as well and are executed sequentially."
  ([f conditions] (run f conditions {}))
  ([f conditions opts]
   (let [{:as opts
          :exoscale.checkmate.hooks/keys [success error failure]
          :exoscale.checkmate/keys [ch]}
         (merge impl/default-options opts)
         ch (or ch (async/promise-chan))
         state (impl/setup-conditions! conditions opts :core-async)]
     (setup-effects! conditions state)
     (async/go-loop [state state]
       (when-let [ret (async/<! (f))]
         (let [state (assoc state ::result ret)]
           (if (instance? Exception ret)
             (if (impl/retry? conditions state)
               (do
                 (error ret)
                 (async/<! (error-effects! conditions state))
                 (recur (impl/update-conditions! conditions state)))
               (do
                 (failure ret)
                 (async/<! (failure-effects! conditions state))
                 (async/>! ch ret)))
             (do
               (success ret)
               (async/<! (success-effects! conditions state))
               (async/>! ch ret))))))
     ch)))
