(ns exoscale.checkmate.manifold
  (:require [exoscale.checkmate.condition :as c]
            [exoscale.checkmate.impl :as impl]
            [manifold.deferred :as d]))

(defn ^:no-doc effects!
  [proto f conditions state]
  (apply d/zip
         (keep #(when (satisfies? proto %)
                  (fn [] (f % state)))
               conditions)))

(def ^:no-doc setup-effects! (partial effects! c/SetupEffect #'c/setup-effect!))
(def ^:no-doc error-effects! (partial effects! c/ErrorEffect #'c/error-effect!))
(def ^:no-doc failure-effects! (partial effects! c/FailureEffect #'c/failure-effect!))
(def ^:no-doc success-effects! (partial effects! c/SuccessEffect #'c/success-effect!))

(defn run
  "Same as do! but returns a deferred, Effects are
  assumed to return deferred as well and are executed sequentially."
  ([f conditions] (run f conditions {}))
  ([f conditions opts]
   (let [{:as opts
          :exoscale.checkmate.hooks/keys [success error failure]}
         (merge impl/default-options opts)
         state (impl/setup-conditions! conditions opts :manifold)]
     (setup-effects! conditions state)
     (d/loop [state state]
       (-> (f)
           (d/chain
            (fn [ret]
              (let [state (assoc state ::result ret)]
                (success ret)
                (d/chain (success-effects! conditions state)
                         (fn [_] ret)))))
           (d/catch Exception
                    (fn [ret]
                      (if (impl/retry? conditions state)
                        (do
                          (error ret)
                          (d/chain (error-effects! conditions state)
                                   (fn [_] (d/recur (impl/update-conditions! conditions state)))))
                        (do
                          (failure ret)
                          (d/chain (failure-effects! conditions state)
                                   (fn [_] (d/error-deferred ret))))))))))))
