(ns exoscale.checkmate.protocols)

;;; Conditions manipulate/query state

(defprotocol Condition
  (setup! [this state]
    "Setups initial state before first run")
  (retry? [this state]
    "Returns true if we should retry upon error on this run")
  (update! [this state]
    "Update state after error"))

;;; Effects

;; Effects potentially run IO at various stage, they take the
;; condition + state, state after setup will contain exoscale.checkmate/result of the
;; current call as well
(defprotocol SetupEffect
  (setup-effect! [this state]
    "Effect triggered before Run"))

(defprotocol SuccessEffect
  (success-effect! [this state]
    "Effect triggered upon success"))

(defprotocol ErrorEffect
  (error-effect! [this state]
    "Effect triggered upon error"))

(defprotocol FailureEffect
  (failure-effect! [this state]
    "Effect triggered upon terminal failure"))
