(defproject exoscale/checkmate "0.2.3"
  :description "By failing to prepare, you are preparing to fail"
  :license {:name "ISC"}
  :url "https://github.com/exoscale/checkmate"
  :deploy-repositories [["releases" :clojars] ["snapshots" :clojars]]
  :dependencies [[org.clojure/clojure "1.10.1"]
                 [org.clojure/core.async "1.2.603"]
                 [cc.qbits/auspex "0.1.0-alpha2"]
                 [exoscale/ex "0.3.9"]
                 [manifold "0.1.8"]
                 [org.clojure/tools.logging "1.1.0"]]
  :profiles {:dev  {:dependencies []}
             :test  {:dependencies []}}
  :pedantic? :warn
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "--no-sign"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
    :global-vars {*warn-on-reflection* true})
