(ns exoscale.checkmate.protocols)

;;; Conditions manipulate/query ctx

(defprotocol Condition
  (setup! [this ctx]
    "Setups initial ctx before first run")
  (retry? [this ctx]
    "Returns true if we should retry upon error on this run")
  (update! [this ctx]
    "Update ctx after error"))

;;; Effects

;; Effects potentially run IO at various stage, they take the
;; condition + ctx, ctx after setup will contain exoscale.checkmate/result of the
;; current call as well
(defprotocol SetupEffect
  (setup-effect! [this ctx]
    "Effect triggered before Run"))

(defprotocol SuccessEffect
  (success-effect! [this ctx]
    "Effect triggered upon success"))

(defprotocol ErrorEffect
  (error-effect! [this ctx]
    "Effect triggered upon error"))

(defprotocol FailureEffect
  (failure-effect! [this ctx]
    "Effect triggered upon terminal failure"))
