(ns exoscale.checkmate.manifold
  (:require [exoscale.checkmate.impl :as impl]
            [exoscale.checkmate.protocols :as p]
            [manifold.deferred :as d]))

(defn ^:no-doc effects!
  [proto f conditions ctx]
  (apply d/zip
         (keep #(when (satisfies? proto %)
                  (fn [] (f % ctx)))
               conditions)))

(def ^:no-doc setup-effects! (partial effects! p/SetupEffect #'p/setup-effect!))
(def ^:no-doc error-effects! (partial effects! p/ErrorEffect #'p/error-effect!))
(def ^:no-doc failure-effects! (partial effects! p/FailureEffect #'p/failure-effect!))
(def ^:no-doc success-effects! (partial effects! p/SuccessEffect #'p/success-effect!))

(defn run
  ([f conditions] (run f conditions {}))
  ([f conditions opts]
   (let [{:as opts :exoscale.checkmate.hook/keys [success error failure]}
         (merge impl/default-options opts)
         ctx (impl/setup-conditions! conditions opts :manifold)]
     (setup-effects! conditions ctx)
     (d/loop [ctx ctx]
       (-> (f)
           (d/chain
            (fn [ret]
              (let [ctx (assoc ctx ::result ret)]
                (success ret)
                (d/chain (success-effects! conditions ctx)
                         (fn [_] ret)))))
           (d/catch Exception
                    (fn [ret]
                      (if (impl/retry? conditions ctx)
                        (do
                          (error ret)
                          (d/chain (error-effects! conditions ctx)
                                   (fn [_] (d/recur (impl/update-conditions! conditions ctx)))))
                        (do
                          (failure ret)
                          (d/chain (failure-effects! conditions ctx)
                                   (fn [_] (d/error-deferred ret))))))))))))
